/*
 * auth.h:
 * This file is automatically generated; please do not edit it.
 */
/* Including auth.p.h at beginning of auth.h file. */

/*
 * Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 * 
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 */

#ifndef __AUTH_AFS_INCL_
#define	__AUTH_AFS_INCL_    1

#include <rx/rxkad.h>			/* to get ticket parameters/contents */

/* super-user pincipal used by servers when talking to other servers */
#define AUTH_SUPERUSER        "afs"

struct ktc_token {
    afs_int32 startTime;
    afs_int32 endTime;
    struct ktc_encryptionKey sessionKey;
    short kvno;  /* XXX UNALIGNED */
    int ticketLen;
    char ticket[MAXKTCTICKETLEN];
};

#ifdef AFS_NT40_ENV
extern int ktc_SetToken(
        struct ktc_principal *server,
        struct ktc_token *token,
        struct ktc_principal *client,
        afs_int32 flags
);

extern int ktc_GetToken(
        struct ktc_principal *server,
        struct ktc_token *token,
        int tokenLen,
        struct ktc_principal *client
);

extern int ktc_ListTokens(
        int cellNum,
        int *cellNumP,
        struct ktc_principal *serverName
);

extern int ktc_ForgetToken(
        struct ktc_principal *server
);

extern int ktc_ForgetAllTokens(void);

/* Flags for the flag word sent along with a token */
#define PIOCTL_LOGON		0x1	/* invoked from integrated logon */

#endif /* AFS_NT40_ENV */

/* Flags for ktc_SetToken() */
#define AFS_SETTOK_SETPAG	0x1
#define AFS_SETTOK_LOGON	0x2	/* invoked from integrated logon */

#endif /* __AUTH_AFS_INCL_ */

/* End of prolog file auth.p.h. */

#define KTC_ERROR                                (11862784L)
#define KTC_TOOBIG                               (11862785L)
#define KTC_INVAL                                (11862786L)
#define KTC_NOENT                                (11862787L)
#define KTC_PIOCTLFAIL                           (11862788L)
#define KTC_NOPIOCTL                             (11862789L)
#define KTC_NOCELL                               (11862790L)
#define KTC_NOCM                                 (11862791L)
#define KTC_RPC                                  (11862792L)
#define KTC_NOCMRPC                              (11862793L)
extern void initialize_KTC_error_table ();
#define ERROR_TABLE_BASE_KTC (11862784L)

/* for compatibility with older versions... */
#define init_KTC_err_tbl initialize_KTC_error_table
#define KTC_err_base ERROR_TABLE_BASE_KTC

/* for compatibility with other users... */
#define ERROR_TABLE_BASE_ktc (11862784L)
#define init_ktc_err_tbl initialize_KTC_error_table
#define initialize_ktc_error_table initialize_KTC_error_table
#define ktc_err_base ERROR_TABLE_BASE_ktc
